-- Tabela de Perfis de Acesso
-- Criada para gerenciar rótulos/perfis de acesso dos usuários

CREATE TABLE IF NOT EXISTS `perfis_acesso` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `nome` varchar(255) NOT NULL,
  `descricao` text DEFAULT NULL,
  `ativo` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_company_id` (`company_id`),
  KEY `idx_ativo` (`ativo`),
  UNIQUE KEY `unique_company_nome` (`company_id`, `nome`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Adicionar coluna perfil_acesso_id na tabela usuarios (se ainda não existir)
-- ALTER TABLE `usuarios` ADD COLUMN `perfil_acesso_id` int(11) DEFAULT NULL AFTER `role`;
-- ALTER TABLE `usuarios` ADD KEY `idx_perfil_acesso_id` (`perfil_acesso_id`);
-- ALTER TABLE `usuarios` ADD CONSTRAINT `fk_usuarios_perfil_acesso` FOREIGN KEY (`perfil_acesso_id`) REFERENCES `perfis_acesso` (`id`) ON DELETE SET NULL;

