-- Tabela auxiliar de Permissões de Perfis de Acesso
-- Armazena as permissões de acesso para cada perfil de acesso

CREATE TABLE IF NOT EXISTS `perfis_acesso_permissoes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `perfil_acesso_id` int(11) NOT NULL,
  `module` varchar(255) NOT NULL,
  `can_view` tinyint(1) NOT NULL DEFAULT 0,
  `can_create` tinyint(1) NOT NULL DEFAULT 0,
  `can_edit` tinyint(1) NOT NULL DEFAULT 0,
  `can_delete` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_company_id` (`company_id`),
  KEY `idx_perfil_acesso_id` (`perfil_acesso_id`),
  KEY `idx_module` (`module`),
  UNIQUE KEY `unique_perfil_module` (`company_id`, `perfil_acesso_id`, `module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Foreign key para perfis_acesso
-- ALTER TABLE `perfis_acesso_permissoes`
-- ADD CONSTRAINT `fk_perfis_acesso_permissoes_perfil`
-- FOREIGN KEY (`perfil_acesso_id`)
-- REFERENCES `perfis_acesso` (`id`)
-- ON DELETE CASCADE;

