-- Tabela auxiliar de Permissões de Movimentos por Módulo
-- Armazena as permissões de movimento específicas para cada módulo de cada perfil

CREATE TABLE IF NOT EXISTS `perfis_acesso_permissoes_movimentos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `perfil_acesso_id` int(11) NOT NULL,
  `permissao_id` int(11) NOT NULL COMMENT 'FK para perfis_acesso_permissoes',
  `module` varchar(255) NOT NULL,
  `movimento` varchar(255) NOT NULL COMMENT 'Nome do movimento (ex: aprovar, cancelar, finalizar)',
  `permitido` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_company_id` (`company_id`),
  KEY `idx_perfil_acesso_id` (`perfil_acesso_id`),
  KEY `idx_permissao_id` (`permissao_id`),
  KEY `idx_module` (`module`),
  KEY `idx_movimento` (`movimento`),
  UNIQUE KEY `unique_permissao_movimento` (`company_id`, `permissao_id`, `movimento`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Foreign keys
-- ALTER TABLE `perfis_acesso_permissoes_movimentos`
-- ADD CONSTRAINT `fk_perfis_acesso_permissoes_movimentos_perfil`
-- FOREIGN KEY (`perfil_acesso_id`)
-- REFERENCES `perfis_acesso` (`id`)
-- ON DELETE CASCADE;

-- ALTER TABLE `perfis_acesso_permissoes_movimentos`
-- ADD CONSTRAINT `fk_perfis_acesso_permissoes_movimentos_permissao`
-- FOREIGN KEY (`permissao_id`)
-- REFERENCES `perfis_acesso_permissoes` (`id`)
-- ON DELETE CASCADE;

