-- Script para adicionar campos específicos do Itaú na tabela contas_bancarias
-- Execute este script apenas se os campos não existirem

-- Adicionar campo client_secret (se não existir)
ALTER TABLE `contas_bancarias`
ADD COLUMN IF NOT EXISTS `client_secret` VARCHAR(255) NULL COMMENT 'Client Secret para integração API (Banco Inter/Itaú)' AFTER `chave_api`;

-- Adicionar campo digito_conta_itau (se não existir)
ALTER TABLE `contas_bancarias`
ADD COLUMN IF NOT EXISTS `digito_conta_itau` VARCHAR(2) NULL COMMENT 'Dígito da conta corrente para Itaú' AFTER `account_number`;

-- Adicionar campo is_producao_itau (se não existir)
ALTER TABLE `contas_bancarias`
ADD COLUMN IF NOT EXISTS `is_producao_itau` TINYINT(1) NOT NULL DEFAULT 0 COMMENT 'Indica se está em produção (1) ou sandbox (0) para Itaú' AFTER `digito_conta_itau`;

ALTER TABLE `users` CHANGE `role` `role` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT 'operator';
ALTER TABLE `tickets` CHANGE `categoria` `categoria` TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '';