<?php
/**
 * Configuração de Skins do Sistema
 *
 * Define as skins disponíveis e suas configurações (cores, logos, etc)
 * A skin ativa é determinada pela tabela configuracoes_sistema no banco de dados
 */

return [
    // Skin padrão (usada como fallback)
    'default' => 'aurion',

    // Configuração de detecção da skin
    'detection' => [
        'source' => 'database', // 'database' ou 'env'
        'table' => 'configuracoes_sistema',
        'key' => 'skin_ativa',
        'fallback_env' => $_ENV['APP_SKIN'] ?? null, // Fallback para variável de ambiente
    ],

    // Definição das skins disponíveis
    'skins' => [
        'aurion' => [
            'name' => 'aurion',
            'display_name' => 'Aurion ERP',
            'logo' => '/storage/uploads/logos/aurion/aurion.png',
            'favicon' => '/public/assets/skins/aurion/favicon.png',
            'css_variables' => '/public/assets/skins/aurion/variables.css',
            'colors' => [
                'primary' => '#001223', // Cor base do tema
                'secondary' => '#6c757d',
                'success' => '#198754',
                'danger' => '#dc3545',
                'warning' => '#ffc107',
                'info' => '#0dcaf0',
            ],
            'dark_mode' => [
                'bg' => '#001223', // Background do dashboard
                'sidebar' => '#001223', // Background do sidebar
                'card' => '#ffffff', // Cards brancos (até segunda ordem)
                'text_primary' => '#ffffff',
                'text_secondary' => '#b0b3b8',
            ],
        ],
        'sanctus' => [
            'name' => 'sanctus',
            'display_name' => 'Sanctus ERP',
            'logo' => '/storage/uploads/logos/sanctus/sanctus.png',
            'favicon' => '/public/assets/skins/sanctus/favicon.png',
            'css_variables' => '/public/assets/skins/sanctus/variables.css',
            'colors' => [
                'primary' => '#122763', // Azul da logo
                'secondary' => '#81007F', // Roxo da logo
                'success' => '#198754',
                'danger' => '#dc3545',
                'warning' => '#ffc107',
                'info' => '#0dcaf0',
            ],
            'dark_mode' => [
                'bg' => '#1a1a1a',
                'sidebar' => '#122763', // Azul da logo como sidebar
                'card' => '#333333',
                'text_primary' => '#ffffff',
                'text_secondary' => '#b0b3b8',
            ],
        ],
    ],
];

