<?php
/**
 * Configurações de Gateways de Pagamento
 */

return [
    // Gateway Asaas
    'asaas' => [
        'enabled' => !empty($_ENV['ASAAS_API_KEY']),
        'api_key' => $_ENV['ASAAS_API_KEY'] ?? '',
        'environment' => $_ENV['ASAAS_ENVIRONMENT'] ?? 'sandbox',
        'webhook_url' => $_ENV['ASAAS_WEBHOOK_URL'] ?? '',
        'base_url' => [
            'sandbox' => 'https://sandbox.asaas.com/api/v3',
            'production' => 'https://api.asaas.com/v3',
        ],
    ],

    // Gateway Stripe
    'stripe' => [
        'enabled' => !empty($_ENV['STRIPE_SECRET_KEY']),
        'public_key' => $_ENV['STRIPE_PUBLIC_KEY'] ?? '',
        'secret_key' => $_ENV['STRIPE_SECRET_KEY'] ?? '',
        'webhook_secret' => $_ENV['STRIPE_WEBHOOK_SECRET'] ?? '',
        'currency' => 'brl',
    ],

    // Gateway Shipay
    'shipay' => [
        'enabled' => !empty($_ENV['SHIPAY_ACCESS_KEY']) && !empty($_ENV['SHIPAY_SECRET_KEY']) && !empty($_ENV['SHIPAY_CLIENT_ID']),
        'access_key' => $_ENV['SHIPAY_ACCESS_KEY'] ?? '',
        'secret_key' => $_ENV['SHIPAY_SECRET_KEY'] ?? '',
        'client_id' => $_ENV['SHIPAY_CLIENT_ID'] ?? '',
        'environment' => $_ENV['SHIPAY_ENVIRONMENT'] ?? 'sandbox',
        'webhook_url' => $_ENV['SHIPAY_WEBHOOK_URL'] ?? '',
        'webhook_secret' => $_ENV['SHIPAY_WEBHOOK_SECRET'] ?? '',
        'base_url' => [
            'sandbox' => 'https://api-staging.shipay.com.br',
            'production' => 'https://api.shipay.com.br',
        ],
    ],

    // Gateway padrão
    'default' => 'asaas',
];

