<?php
/**
 * Configurações de Banco de Dados
 */

// Suporta modo simples (DB_HOST) e modo multi-tenant (DB_MASTER_HOST)
$host = $_ENV['DB_HOST'] ?? $_ENV['DB_MASTER_HOST'] ?? 'localhost';
$port = $_ENV['DB_PORT'] ?? $_ENV['DB_MASTER_PORT'] ?? 3306;
$database = $_ENV['DB_NAME'] ?? $_ENV['DB_MASTER_NAME'] ?? 'Systhema_tenant_master';
$username = $_ENV['DB_USER'] ?? $_ENV['DB_MASTER_USER'] ?? 'root';
$password = $_ENV['DB_PASS'] ?? $_ENV['DB_MASTER_PASS'] ?? '';

return [
    // Banco Master (gerencia tenants, usuários, assinaturas)
    'master' => [
        'driver' => 'mysql',
        'host' => $host,
        'port' => $port,
        'database' => $database,
        'username' => $username,
        'password' => $password,
        'charset' => 'utf8mb4',
        'collation' => 'utf8mb4_unicode_ci',
        'prefix' => '',
        'options' => [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci"
        ],
    ],

    // Configurações para bancos dos tenants
    'tenant' => [
        'driver' => 'mysql',
        'host' => $host,
        'port' => $port,
        'prefix' => $_ENV['DB_TENANT_PREFIX'] ?? '',
        'username' => $username,
        'password' => $password,
        'charset' => 'utf8mb4',
        'collation' => 'utf8mb4_unicode_ci',
        'options' => [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci"
        ],
    ],
];

