<?php
/**
 * Configurações Gerais da Aplicação
 */

return [
    'name' => $_ENV['APP_NAME'] ?? 'Aurion ERP',
    'env' => $_ENV['APP_ENV'] ?? 'production',
    'debug' => filter_var($_ENV['APP_DEBUG'] ?? false, FILTER_VALIDATE_BOOLEAN),
    'url' => $_ENV['APP_URL'] ?? 'http://localhost',
    'timezone' => $_ENV['APP_TIMEZONE'] ?? 'America/Sao_Paulo',

    // Configurações de sessão
    'session' => [
        'lifetime' => (int) ($_ENV['SESSION_LIFETIME'] ?? 7200),
        'secure' => filter_var($_ENV['SESSION_SECURE'] ?? false, FILTER_VALIDATE_BOOLEAN),
        'http_only' => filter_var($_ENV['SESSION_HTTP_ONLY'] ?? true, FILTER_VALIDATE_BOOLEAN),
        'same_site' => 'Lax',
        'name' => 'Systhema_SESSION',
    ],

    // Configurações de segurança
    'security' => [
        'jwt_secret' => $_ENV['JWT_SECRET'] ?? '',
        'encryption_key' => $_ENV['ENCRYPTION_KEY'] ?? '',
        'password_min_length' => 8,
        'password_require_special' => true,
        'password_require_numbers' => true,
        'password_require_uppercase' => true,
    ],

    // Configurações de upload
    'upload' => [
        'max_size' => (int) ($_ENV['UPLOAD_MAX_SIZE'] ?? 5242880), // 5MB
        'allowed_extensions' => explode(',', $_ENV['UPLOAD_ALLOWED_EXTENSIONS'] ?? 'jpg,jpeg,png,pdf'),
        'path' => ROOT_PATH . '/storage/uploads',
    ],

    // Configurações de cache
    'cache' => [
        'driver' => $_ENV['CACHE_DRIVER'] ?? 'file',
        'lifetime' => (int) ($_ENV['CACHE_LIFETIME'] ?? 3600),
        'path' => ROOT_PATH . '/storage/cache',
    ],

    // Configurações de log
    'log' => [
        'level' => $_ENV['LOG_LEVEL'] ?? 'error',
        'channel' => $_ENV['LOG_CHANNEL'] ?? 'daily',
        'path' => ROOT_PATH . '/storage/logs',
    ],

    // Planos de assinatura
    'plans' => [
        'free' => [
            'name' => 'Free',
            'price' => 0,
            'users' => 2,
            'companies' => 1,
            'storage' => 100, // MB
            'invoices_per_month' => 20,
            'features' => [
                'basic_reports',
            ],
        ],
        'pro' => [
            'name' => 'Pro',
            'price' => 99.90,
            'users' => 10,
            'companies' => 3,
            'storage' => 1024, // 1GB
            'invoices_per_month' => 500,
            'features' => [
                'basic_reports',
                'advanced_reports',
                'api_access',
                'priority_support',
            ],
        ],
        'enterprise' => [
            'name' => 'Enterprise',
            'price' => 299.90,
            'users' => -1, // ilimitado
            'companies' => -1, // ilimitado
            'storage' => 10240, // 10GB
            'invoices_per_month' => -1, // ilimitado
            'features' => [
                'basic_reports',
                'advanced_reports',
                'custom_reports',
                'api_access',
                'priority_support',
                'dedicated_manager',
                'custom_integrations',
            ],
        ],
    ],
];