<?php
require_once __DIR__ . '/vendor/autoload.php';

use App\Helpers\CnpjHelper;

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$cnpj = $_GET['cnpj'] ?? '';

// Valida primeiro
if (!CnpjHelper::validar($cnpj)) {
    echo json_encode([
        'success' => false,
        'message' => 'CNPJ inválido'
    ]);
    exit;
}

$resultado = CnpjHelper::buscar($cnpj);

if ($resultado) {
    echo json_encode([
        'success' => true,
        'data' => $resultado
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'CNPJ não encontrado ou serviço indisponível'
    ]);
}

